<?php
// test_voter.php
$targetUrl = 'https://print.directservices.in/api/generate.php';

// Voter ID Test Data
$testData = [
    'service_type' => 'VOTER',
    'voter_id' => 'ABC1234567',
    'name' => 'RAHUL KUMAR',
    'father_name' => 'SURESH PRASAD',
    'gender' => 'MALE',
    'dob' => '15/08/1995',
    'address' => 'H.NO 123, VILLAGE RAMPUR, POST OFFICE RAMPUR, DISTRICT SITAMARHI, BIHAR - 843301',
    'name_regional' => 'राहुल कुमार',
    'father_name_regional' => 'सुरेश प्रसाद',
    'address_regional' => 'म.न. 123, ग्राम रामपुर, पोस्ट रामपुर, जिला सीतामढ़ी, बिहार - 843301',
    'assembly' => '31 - SITAMARHI',
    'part_no' => '145',
    'part_name' => 'GOVT MIDDLE SCHOOL RAMPUR',
    'sl_no_in_part' => '850',
    'house_no' => '123',
    'state' => 'BIHAR',
    'photo' => '', // Aap yahan base64 image string daal sakte hain
    'header_details' => [
        'card_issued_date' => date('d-m-Y')
    ]
];

$jsonData = json_encode($testData);
?>

<!DOCTYPE html>
<html lang="hi">
<head>
    <meta charset="UTF-8">
    <title>Voter ID Generate Test</title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #f4f7f6; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .container { background: white; padding: 30px; border-radius: 15px; box-shadow: 0 8px 20px rgba(0,0,0,0.1); text-align: center; width: 420px; border-top: 5px solid #ff9933; }
        h2 { color: #000080; margin-bottom: 15px; }
        .info { background: #fff3e0; padding: 15px; border-radius: 10px; margin-bottom: 20px; font-size: 14px; text-align: left; border: 1px solid #ffcc80; }
        button { background: #000080; color: white; border: none; padding: 12px 20px; font-size: 16px; border-radius: 8px; cursor: pointer; width: 100%; font-weight: bold; transition: 0.3s; }
        button:hover { background: #000060; transform: scale(1.02); }
    </style>
</head>
<body>

<div class="container">
    <h2>Voter Print Portal</h2>
    <div class="info">
        <strong>Voter ID:</strong> ABC1234567<br>
        <strong>Name:</strong> RAHUL KUMAR<br>
        <strong>State:</strong> BIHAR<br>
        <strong>Service:</strong> Voter Manual Print
    </div>
    
    <form action="<?php echo $targetUrl; ?>" method="POST" target="_blank">
        <input type="hidden" name="printdata" value='<?php echo htmlspecialchars($jsonData, ENT_QUOTES, "UTF-8"); ?>'>
        <button type="submit">Print Voter Card PDF</button>
    </form>
</div>

</body>
</html>