<?php
// api/routes/dl_final.php
error_reporting(0);
ini_set('display_errors', 0);
ini_set('pcre.backtrack_limit', '10000000');

if (!class_exists('\Mpdf\Mpdf')) {
    $autoloadPath = __DIR__ . '/../../libs/vendor/autoload.php';
    require_once (file_exists($autoloadPath)) ? $autoloadPath : __DIR__ . '/../../vendor/autoload.php';
}

// 1. IMAGE HANDLING
$serverRoot = '/home/directse1/print.directservices.in';
$imagePath = $serverRoot . '/assets/templates/licensenormal.jpg'; 
$base64Image = file_exists($imagePath) ? 'data:image/jpg;base64,' . base64_encode(file_get_contents($imagePath)) : '';

// 2. DATA MAPPING (Cleaned from citation tags)
$dlNo        = $data['dl_no'] ?? 'MP0620250015760';
$issueDate   = $data['issue_date'] ?? '14-12-2025';
$validityNT  = $data['validity_nt'] ?? '13-12-2035';
$name        = strtoupper($data['name'] ?? 'MATA PRASAD KUSHWAH');
$parentName  = strtoupper($data['parent_name'] ?? 'RAMDAS');
$dob         = $data['dob'] ?? '12-06-1990';
$bloodGroup  = $data['blood_group'] ?? 'O+';
$address     = strtoupper($data['address'] ?? 'CHENTA MUKUNDI KA PURA BARETHA BARETHA MORENA MADHYA PRADESH - 476001');
$auth        = strtoupper($data['auth'] ?? 'RTO, MORENA RTO');

$photo       = $data['profile_image'] ?? ''; 
$signature   = $data['signature_image'] ?? '';

// 3. mPDF Setup
$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8', 
    'format' => [210, 297], 
    'orientation' => 'P',
    'margin_left' => 0, 'margin_right' => 0, 'margin_top' => 0, 'margin_bottom' => 0,
    'default_font' => 'arial'
]);

// 4. FIXED BACKGROUND (Voter Style)
if (!empty($base64Image)) {
    $mpdf->WriteHTML("
        <div style='position: fixed; left: 0; top: 0; width: 210mm; height: 297mm; z-index: -1000;'>
            <img src='{$base64Image}' style='width: 210mm; height: 297mm;' />
        </div>
    ");
}

// 5. CSS FOR FIELDS
$f_bold = "font-weight: 900; text-shadow: 0.3pt 0.3pt 0.1pt #000;";
$css = '
    body { font-family: "arial", sans-serif; color: #000; margin:0; padding:0; text-transform: uppercase; }
    .field { position: absolute; z-index: 10; white-space: nowrap; }
';
$mpdf->WriteHTML($css, 1);

// 6. CONTENT ASSEMBLY
$html = '
    <div class="field" style="top: 55px; left: 145px; font-size: 11.5px; '.$f_bold.'">MADHYA PRADESH</div>
    <div class="field" style="top: 103px; left: 125px; font-size: 10px; '.$f_bold.'">'.$issueDate.'</div>
    <div class="field" style="top: 103px; left: 220px; font-size: 10px; '.$f_bold.'">'.$validityNT.'</div>
    
    <div class="field" style="top: 153px; left: 85px; font-size: 10.5px; '.$f_bold.'">'.$name.'</div>
    <div class="field" style="top: 168px; left: 85px; font-size: 10px; '.$f_bold.'">'.$dob.'</div>
    <div class="field" style="top: 168px; left: 240px; font-size: 10px; '.$f_bold.'">'.$bloodGroup.'</div>
    <div class="field" style="top: 183px; left: 110px; font-size: 10px; '.$f_bold.'">'.$parentName.'</div>
    
    <div class="field" style="top: 198px; left: 85px; width: 320px; font-size: 9px; '.$f_bold.' white-space: normal; line-height: 1.2;">'.$address.'</div>

    '.($photo ? '<div style="position: absolute; top: 75px; left: 25px; z-index: 999;"><img src="'.$photo.'" style="width: 78px; height: 90px;" /></div>' : '').'
    '.($signature ? '<div style="position: absolute; top: 155px; left: 380px; z-index: 999;"><img src="'.$signature.'" style="width: 80px; height: 25px; mix-blend-mode: multiply;" /></div>' : '').'

    <div class="field" style="top: 43px; left: 560px; font-size: 12.5px; '.$f_bold.' color: #fff; letter-spacing: 1px;">'.$dlNo.'</div>
    <div class="field" style="top: 205px; left: 825px; font-size: 10.5px; '.$f_bold.' text-align: center;">'.$auth.'</div>
    
    <div class="field" style="top: 145px; left: 540px; font-size: 9.5px; '.$f_bold.'">MCWG</div>
    <div class="field" style="top: 145px; left: 585px; font-size: 9.5px; '.$f_bold.'">MP06</div>
    <div class="field" style="top: 145px; left: 700px; font-size: 9.5px; '.$f_bold.'">'.$issueDate.'</div>
';

$mpdf->WriteHTML($html, 2);
$mpdf->Output('DL_'.$dlNo.'.pdf', 'I');